@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('Perusahaan Saya') }}</div>

                <div class="card-body">

                  <div class="col-md-8">
                    <h2>Tambah Perusahaan</h2>
                    <a href="{{ url('/perusahaanSaya') }}">Lihat Perusahaan Saya</a>
                    <form action="/perusahaan/tambah" method="post">
                          {{ csrf_field() }}
                          <div class="form-group row">
                              <label for="name" class="col-md-4 col-form-label text-md-right">Nama Perusahaan</label>

                              <div class="col-md-8">
                                  <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus>

                                  @error('name')
                                      <span class="invalid-feedback" role="alert">
                                          <strong>{{ $message }}</strong>
                                      </span>
                                  @enderror
                              </div>
                          </div>

                          <div class="form-group row">
                              <label for="email" class="col-md-4 col-form-label text-md-right">Email Perusahaan</label>

                              <div class="col-md-8">
                                  <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email">

                                  @error('email')
                                      <span class="invalid-feedback" role="alert">
                                          <strong>{{ $message }}</strong>
                                      </span>
                                  @enderror
                              </div>
                          </div>

                          <div class="form-group row">
                            <label for="kategori" class="col-md-4 col-form-label text-md-right">Email Perusahaan</label>

                            <div class="col-md-8">
                              <select class="form-control" name="kategori" required>
                                <option>Pilih kategori perusahaan anda</option>
                                <option>Kecatikan</option>
                                <option>Industrial</option>
                                <option>Wirausaha</option>
                              </select>
                            </div>
                          </div>

                          <div class="form-group row">
                              <label for="deskripsi" class="col-md-4 col-form-label text-md-right">Deskripsi</label>

                              <div class="col-md-8">
                                  <textarea id="deskripsi" type="text" class="form-control" name="deskripsi" required></textarea>

                              </div>
                          </div>

                          <div class="form-group row">
                            <div class="col-md-8">
                              <button type="submit" class="btn btn-primary">Tambah</button>
                            <div>
                          </div>
                    </form>
                  </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
